/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.enu.WetSource;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.talent.HellHoundTalent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class FisherDogTalent
extends TalentInstance {
    private int cookCooldown = 10;
    private boolean renderHat = true;

    public FisherDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (this.cookCooldown > 0) {
            --this.cookCooldown;
        }
    }

    @Override
    public void onShakingDry(AbstractDog dogIn, WetSource source) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!source.isWaterBlock()) {
            return;
        }
        int r_fish = dogIn.m_217043_().m_188503_(15);
        if (r_fish >= this.level() * 2) {
            return;
        }
        ItemStack fishItem = this.getRandomFishingLoot(dogIn);
        ItemStack fishStack = this.getFishedStack(dogIn, fishItem);
        dogIn.m_19983_(fishStack);
    }

    private ItemStack getRandomFishingLoot(AbstractDog dog) {
        Level level = dog.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return ItemStack.f_41583_;
        }
        ServerLevel sLevel = (ServerLevel)level;
        ResourceLocation loot_table = BuiltInLootTables.f_78723_;
        RandomSource r = dog.m_217043_();
        if (this.level() >= 5 && (double)r.m_188501_() < 0.0125) {
            loot_table = BuiltInLootTables.f_78722_;
        }
        LootParams loot_param = new LootParams.Builder(sLevel).m_287235_(LootContextParamSets.f_81410_);
        ObjectArrayList loot_list = sLevel.m_7654_().m_278653_().m_278676_(loot_table).m_287195_(loot_param);
        if (loot_list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack ret = (ItemStack)loot_list.get(r.m_188503_(loot_list.size()));
        return ret.m_41777_();
    }

    private ItemStack getFishedStack(AbstractDog dog, ItemStack raw_stack) {
        raw_stack = this.mayCookFish(dog, raw_stack);
        return raw_stack;
    }

    private ItemStack mayCookFish(AbstractDog dog, ItemStack fish_raw) {
        float r;
        if (this.cookCooldown > 0) {
            return fish_raw;
        }
        Optional hellhound_optional = dog.getTalent((Supplier)DoggyTalents.HELL_HOUND);
        if (!hellhound_optional.isPresent()) {
            return fish_raw;
        }
        Object t = hellhound_optional.get();
        if (!(t instanceof HellHoundTalent)) {
            return fish_raw;
        }
        HellHoundTalent hellhound = (HellHoundTalent)t;
        if (!hellhound.canGenerateHeat()) {
            return fish_raw;
        }
        if (hellhound.level() < hellhound.getTalent().getMaxLevel() && (r = dog.m_217043_().m_188501_()) > 0.75f) {
            return fish_raw;
        }
        this.cookCooldown = 10;
        return this.tryCookFish(dog, fish_raw);
    }

    private ItemStack tryCookFish(AbstractDog dog, ItemStack fish_raw) {
        RecipeManager recipeMan = dog.m_9236_().m_7465_();
        Optional recipeOptional = recipeMan.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{fish_raw.m_41777_()}), dog.m_9236_());
        if (!recipeOptional.isPresent()) {
            return fish_raw;
        }
        SmeltingRecipe recipe = (SmeltingRecipe)recipeOptional.get();
        ItemStack resultStack = recipe.m_8043_(dog.m_9236_().m_9598_());
        if (resultStack == null || resultStack.m_41619_()) {
            return fish_raw;
        }
        return resultStack.m_41777_();
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.renderHat = compound.m_128471_("renderHat");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("renderHat", this.renderHat);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            return this.renderHat;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            this.renderHat = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FISHER_DOG_RENDER.get());
    }

    public boolean canRenderHat() {
        return this.level() >= this.getTalent().getMaxLevel();
    }

    public boolean renderHat() {
        return this.renderHat;
    }

    public void setRenderHat(boolean hat) {
        this.renderHat = hat;
    }
}

